CREATE PROCEDURE CP_Finan_Creditos(
				@pAmort			CHAR(1)
			,	@pCuotas		SMALLINT
			,	@pTEM			DECIMAL(12,4)
			,	@pCapital		DECIMAL(12,4)
			,	@pFechaDesde	DATETIME
			,	@pNroCutoa		SMALLINT
			)
AS
 
IF  @pAmort NOT IN ('T','F','A','U')
    RETURN

DECLARE @NroCuota SMALLINT
      , @SaldoInicial	DECIMAL(16,2)
	  , @ValorCuota		DECIMAL(16,2)
	  , @Intereses		DECIMAL(16,2)
	  , @Amortizacion	DECIMAL(16,2) 
	  , @AmortACum		DECIMAL(16,2) 
	  , @SaldoFinal		DECIMAL(16,2)
	  , @Fecha			DATETIME
	  , @DifDias	    TINYINT

CREATE TABLE #Result (
	    Fecha			DATETIME
      , NroCuota		SMALLINT 
      , SaldoInicial	DECIMAL(16,2)
	  , ValorCuota		DECIMAL(16,2)
	  , Intereses		DECIMAL(16,2)
	  , Amortizacion	DECIMAL(16,2) 
	  , AmortACum		DECIMAL(16,2) 
	  , SaldoFinal		DECIMAL(16,2)
	  )

SET @NroCuota = 1
SET @SaldoInicial	= @pCapital
SET @AmortACum = 0
SET @Fecha = @pFechaDesde

/*Cuota Cero*/
SET @DifDias = DATEDIFF(dd,@Fecha,EOMONTH(@Fecha))
IF ISNULL(@DifDias,0) != 0
BEGIN
		SET @Intereses		= @pCapital * (@pTEM / 100 / 30) * @DifDias
		SET @Amortizacion	= 0
		SET @ValorCuota		= @Intereses + @Amortizacion
		SET @AmortACum		= 0
		SET @SaldoFinal		= @pCapital 
		INSERT INTO #Result VALUES (@Fecha,0 , @SaldoInicial, @ValorCuota, @Intereses, @Amortizacion, @AmortACum, @SaldoFinal)
END 


SET @Fecha = EOMONTH(@Fecha) 
SET @Fecha = DATEADD(dd,1,@Fecha) 


WHILE @NroCuota <= @pCuotas
BEGIN
    IF UPPER(@pAmort) = 'T'   -- Tasa directa
	BEGIN
		SET @Intereses		= @pCapital * @pTEM / 100
		SET @Amortizacion	= @pCapital / @pCuotas
		SET @ValorCuota		= @Intereses + @Amortizacion
		SET @AmortACum		= @AmortACum + @Amortizacion
		SET @SaldoFinal		= @pCapital - @AmortACum
    END

    IF UPPER(@pAmort) = 'F'   -- Frances
	BEGIN
		SET @ValorCuota		= @pCapital * ( @pTEM / 100) / (1 -(POWER( (1+( @pTEM / 100)),(@pCuotas * -1) ) ) )   
		SET @Intereses		= @SaldoInicial * @pTEM / 100
		SET @Amortizacion	= @ValorCuota - @Intereses
		SET @AmortACum		= @AmortACum + @Amortizacion
		SET @SaldoFinal		= @pCapital - @AmortACum
    END

    IF UPPER(@pAmort) = 'A'   -- Aleman
	BEGIN
		SET @ValorCuota		= (@pCapital / @pCuotas) + ( @SaldoInicial * ( @pTEM / 100) )
		SET @Intereses		= @SaldoInicial * @pTEM / 100
		SET @Amortizacion	= @pCapital / @pCuotas
		SET @AmortACum		= @AmortACum + @Amortizacion
		SET @SaldoFinal		= @pCapital - @AmortACum
    END

    IF UPPER(@pAmort) = 'U'   -- Americano
	BEGIN
		SET @Intereses		= @pCapital * @pTEM / 100
		IF @NroCuota = @pCuotas
			SET @Amortizacion	= @pCapital  
		ELSE 
			SET @Amortizacion	= 0 
		SET @ValorCuota		= @Intereses + @Amortizacion
		SET @AmortACum		= @AmortACum + @Amortizacion
		SET @SaldoFinal		= @pCapital - @AmortACum

    END

    INSERT INTO #Result VALUES (@Fecha,@NroCuota , @SaldoInicial, @ValorCuota, @Intereses, @Amortizacion, @AmortACum, @SaldoFinal)
	SET @NroCuota = @NroCuota + 1
	SET @SaldoInicial = @SaldoFinal
	SET @Fecha = DATEADD(mm,1,@Fecha)
END 

IF @SaldoFinal <> 0 
BEGIN
	UPDATE #Result SET Amortizacion = @Amortizacion + @SaldoFinal
	                 , ValorCuota = @ValorCuota + @SaldoFinal 
					 , AmortACum = @AmortACum + @SaldoFinal
					 , SaldoFinal = 0
	WHERE NroCuota = @pCuotas
END
IF ISNULL(@pNroCutoa,0) = 0
   SELECT * FROM #Result
ELSE
   SELECT * FROM #Result WHERE NroCuota = @pNroCutoa



DROP TABLE #Result

